<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\Warehouse\OutgoingTransaction;

echo "=== MATERIAL REQUESTS FILTER TEST ===\n\n";

echo "ALL Outgoing Transactions (BEFORE filter):\n";
$allTransactions = OutgoingTransaction::orderBy('created_at', 'desc')
    ->get(['id', 'material_request_number', 'type_of_goods', 'status', 'created_at']);

foreach($allTransactions as $t) {
    echo "ID: {$t->id} - MR: {$t->material_request_number} - Type: " . ($t->type_of_goods ?? 'NULL') . " - Status: {$t->status} - Created: {$t->created_at}\n";
}

echo "\nFiltered Material Requests (AFTER filter - excluding -INV):\n";
$filteredTransactions = OutgoingTransaction::where('material_request_number', 'not like', '%-INV')
    ->orderBy('created_at', 'desc')
    ->get(['id', 'material_request_number', 'type_of_goods', 'status', 'created_at']);

foreach($filteredTransactions as $t) {
    echo "ID: {$t->id} - MR: {$t->material_request_number} - Type: " . ($t->type_of_goods ?? 'NULL') . " - Status: {$t->status} - Created: {$t->created_at}\n";
}

echo "\n=== STATISTICS TEST ===\n";
echo "Total requests (all): " . OutgoingTransaction::count() . "\n";
echo "Total requests (filtered): " . OutgoingTransaction::where('material_request_number', 'not like', '%-INV')->count() . "\n";
echo "Pending requests (all): " . OutgoingTransaction::where('status', 'pending')->count() . "\n";
echo "Pending requests (filtered): " . OutgoingTransaction::where('status', 'pending')->where('material_request_number', 'not like', '%-INV')->count() . "\n";
echo "Successful requests (all): " . OutgoingTransaction::where('status', 'successful')->count() . "\n";
echo "Successful requests (filtered): " . OutgoingTransaction::where('status', 'successful')->where('material_request_number', 'not like', '%-INV')->count() . "\n";

echo "\n=== RESULT ===\n";
echo "✅ Material requests page will now show only original requests\n";
echo "✅ Internal inventory transactions (-INV) are properly excluded\n";
echo "✅ Statistics correctly reflect only actual material requests\n";